;************************************************************************
;* Microcontroller Z8 Z86E08 2K programm small lightshow in 11 bits     *
;* Made by Thomas Scherrer-Tangen.      mailto:tscherrer@cybernet.dk    *
;* Date 4/4 1996                                                        *
;*         The 11 LEDs shuld be located in this order:                  *
;*   Bits:       2 1 0 7 6 5 4 3 2 1 0                                  *
;*   Port nr:    0 0 0 2 2 2 2 2 2 2 2                                  *
;*   Pins:  13,12,11,4,3,2,1,18,17,16,15                                *
;* My Crystal is 4.19 MHz, but use what you have and edit the divider   *
;* Sorry some labels is in Danish ;)                                    *
;************************************************************************
POINTER_HI      .equ    R12                     ; High first, 8 bit 
POINTER_LO      .equ    R13                     ; Low second, 8 bit
POINTER         .equ    RR12                    ; The 16bit table pointer


                .ORG 000CH                      ; reset adr.
INIT:           DI                              ; dissable all interrupts
                LD      RP,#00001111B           ; point to
                LD      R0,#11111110B           ; pcon reg
             ;  LD      R11,#00000001B          ; crystal div by 2x16
                LD      R11,#00000000B          ; crystal div by 2 (default)
             ;  LD      R11,#00000010B          ; crystal div by 0
               
                SRP     #10h                    ; register bank 1
                LD      SPL,#7FH                ; this stack is ok for all Z8
                LD      P3M,#00000001B
                CLR     P2M                     ; PORT2 OUT 
                LD     P01M,#00000100B          ; PORT0 OUT active


;************************************************************************
;               HERE IS MAIN PROGRAM                                    *
;************************************************************************
IGEN:           LD      R15,#15
                CALL    MODMIDT2
                LD      R15,#5
                LD      R6,#4
IGEN1:          CALL    SINUS
                INC     R15
                DJNZ    R6,IGEN1
                   
                LD      R15,#55
                CALL    FRAMIDT2
                CALL    FADE_OP
                CALL    FADER
                CALL    FADER
                CALL    FADER
                CALL    FADE_NED

                LD      R15,#15
                CALL    L0BVEN_ALL
                LD      R15,#11

                CALL    FRA_ALL
                CALL    TIL_ALL
                CALL    FRA_ALL

                LD      R15,#8
                LD      R6,#4
IGEN1A:         CALL    FRAMTIL
                DEC     R15
                DJNZ    R6,IGEN1A
                LD      R15,#30
                CALL    FRAMIDT2

                LD      R15,#90
                CALL    START3PRIK
                LD      R15,#60
                CALL    PRIK3_VEN
                LD      R15,#30
                CALL    PRIK3_VEN
                CALL    PRIK3_VEN
                CALL    PRIK3_VEN
                CALL    PRIK3_SKIFT
                CALL    PRIK3_SKIFT
                CALL    PRIK3_SKIFT
                CALL    PRIK3_K0R
                CALL    PRIK3_K0R
                CALL    PRIK3_K0R
                LD      R15,#50
                CALL    PRIK3_VEN
                LD      R15,#90
                CALL    SLUT3PRIK

                LD      R15,#30
                CALL    JIM_INTRO
                LD      R15,#20
                CALL    JIM_LOOP1
                LD      R15,#10
                LD      R6,#4
IGEN2A:         CALL    JIM_LOOP1
                DJNZ    R6,IGEN2A
                LD      R15,#14
                LD      R6,#6
IGEN2B:         CALL    JIM_LOOP_SINE
                DJNZ    R6,IGEN2B
                CALL    JIM_LOOP1
                CALL    JIM_LOOP_SINE
                CALL    JIM_LOOP1
                CALL    JIM_LOOP_SINE

                LD      R15,#40
                CALL    JIM_OUTRO
                LD      R15,#200
                CALL    PAUSE

                LD      R15,#15
                CALL    L0BH0J2
                CALL    L0BVEN2
                LD      R6,#6
                LD      R15,#9
IGEN2:          CALL    L0BH0J2
                CALL    L0BVEN2
                DEC     R15
                DJNZ    R6,IGEN2
                LD      R6,#3
IGEN3:          CALL    L0BH0J2
                CALL    L0BVEN2
                DJNZ    R6,IGEN3


                LD      R15,#5
                CALL    MODMIDT2
                CALL    FRAMIDT2
                LD      R15,#8
                CALL    MODMIDT2
                CALL    FRAMIDT2
                LD      R15,#12
                CALL    MODMIDT2
                CALL    FRAMIDT2
                JP      IGEN


;************************************************************************
; THISE SUBS IS MADE TO SAVE SOME BYTES, COZ THIS CODE IS USED ALOT.
; SINCE YOU CAN'T LOAD A 16BIT REGISTER DIRECT, I LOAD IT IN 8 BIT-
; WITH THE COMMAND #^HB FOR HIGH BYTE, AND SO ON. GOT IT??

JIM_INTRO:      LD      POINTER_HI,#^HB D_JIM_INTRO
                LD      POINTER_LO,#^LB D_JIM_INTRO
                CALL    TABELPLAY
                RET

JIM_OUTRO:      LD      POINTER_HI,#^HB D_JIM_OUTRO
                LD      POINTER_LO,#^LB D_JIM_OUTRO
                CALL    TABELPLAY
                RET

JIM_LOOP1:      LD      POINTER_HI,#^HB D_JIM_LOOP1
                LD      POINTER_LO,#^LB D_JIM_LOOP1
                CALL    TABELPLAY
                RET

JIM_LOOP_SINE:  LD      POINTER_HI,#^HB D_JIM_LOOP_SINE
                LD      POINTER_LO,#^LB D_JIM_LOOP_SINE
                CALL    TABELPLAY
                RET

START3PRIK:     LD      POINTER_HI,#^HB D_START3PRIK
                LD      POINTER_LO,#^LB D_START3PRIK
                CALL    TABELPLAY
                RET

SLUT3PRIK:      LD      POINTER_HI,#^HB D_SLUT3PRIK
                LD      POINTER_LO,#^LB D_SLUT3PRIK
                CALL    TABELPLAY
                RET

PRIK3_VEN:      LD      POINTER_HI,#^HB D_3PRIK_VEN
                LD      POINTER_LO,#^LB D_3PRIK_VEN
                CALL    TABELPLAY
                RET

PRIK3_SKIFT:    LD      POINTER_HI,#^HB D_3PRIK_SKIFT
                LD      POINTER_LO,#^LB D_3PRIK_SKIFT
                CALL    TABELPLAY
                RET

PRIK3_K0R:      LD      POINTER_HI,#^HB D_3PRIK_K0R
                LD      POINTER_LO,#^LB D_3PRIK_K0R
                CALL    TABELPLAY
                RET

L0BH0J2:        LD      POINTER_HI,#^HB D_L0BH0J2
                LD      POINTER_LO,#^LB D_L0BH0J2
                CALL    TABELPLAY
                RET

L0BVEN2:        LD      POINTER_HI,#^HB D_L0BVEN2
                LD      POINTER_LO,#^LB D_L0BVEN2
                CALL    TABELPLAY
                RET

L0BVEN_ALL:     LD      POINTER_HI,#^HB D_L0BVEN_ALL
                LD      POINTER_LO,#^LB D_L0BVEN_ALL
                CALL    TABELPLAY
                RET

MODMIDT2:       LD      POINTER_HI,#^HB D_MODMIDT2
                LD      POINTER_LO,#^LB D_MODMIDT2
                CALL    TABELPLAY
                RET

FRAMIDT2:       LD      POINTER_HI,#^HB D_FRAMIDT2
                LD      POINTER_LO,#^LB D_FRAMIDT2
                CALL    TABELPLAY
                RET

SINUS:          LD      POINTER_HI,#^HB D_SINUS
                LD      POINTER_LO,#^LB D_SINUS
                CALL    TABELPLAY
                RET

FRAMTIL:        LD      POINTER_HI,#^HB D_FREMTIL
                LD      POINTER_LO,#^LB D_FREMTIL
                CALL    TABELPLAY
                RET

FRA_ALL:        LD      POINTER_HI,#^HB D_FRA_ALL
                LD      POINTER_LO,#^LB D_FRA_ALL
                CALL    TABELPLAY
                RET

TIL_ALL:        LD      POINTER_HI,#^HB D_TIL_ALL
                LD      POINTER_LO,#^LB D_TIL_ALL
                CALL    TABELPLAY
                RET


;***************************************************************************

FADER:          LD      R1,#10         ; NUMBER SAMPLES IN TABEL PR. VALUE.
                LD      R3,#80         ; NUMBER REPEAT THE SAME LEVEL (SPEED)
                LD      R2,R3
                LD      POINTER_HI,#^HB D_FADER
                LD      POINTER_LO,#^LB D_FADER
                CALL    FADERPLAY
                RET

FADE_OP:        LD      R1,#10
                LD      R2,#150
                LD      R3,R2
                LD      POINTER_HI,#^HB D_FADE_OP
                LD      POINTER_LO,#^LB D_FADE_OP
                CALL    FADERPLAY
                RET

FADE_NED:       LD      R1,#10
                LD      R2,#250
                LD      R3,R2
                LD      POINTER_HI,#^HB D_FADE_NED
                LD      POINTER_LO,#^LB D_FADE_NED
                CALL    FADERPLAY
                RET

;***************************************************************************
; HERE IS A SIMPLE TABLE LOOK UP.
TABELPLAY:      LDC     R14,@POINTER   ; GET DATA FROM "POINTER" LOCATION.
                CP      R14,#0FFH      ; TJECK IF END CARAKTER.
                JP      Z,TABEL_END
                LD      P0,R14         ; OUTPUT THE LOW DATA.
                INCW    POINTER        ; POINT TO HIGH LOCATION
                LDC     R14,@POINTER   ; GET DATA
                LD      P2,R14         ; OUTPUT THE HIGH DATA.
                INCW    POINTER
                CALL    PAUSE          ; SOME DALAY
                JP      TABELPLAY
TABEL_END:      RET


;***************************************************************************
; HERE IS THE FADER PLAYER, IT CAN MODULATE THE POWER IN THE LEDS-
; FOR VARIABLE INTENSITY. THIS LOOKS REALY COOL.

FADERPLAY:      LDC     R14,@POINTER   ; GET DATA FROM "POINTER"
                CP      R14,#0FFH      ; TJECK END?
                JP      Z,TABEL_END
                LD      P0,R14         ; OUT DATA LOW BITS
                INCW    POINTER        ; NEXT
                LDC     R14,@POINTER   ; GET DATA
                LD      P2,R14         ; OUT DATA HIGH BITS

                LD      R4,#30         ; SMALL DELAY
PA4LOOP:        NOP
                DJNZ    R4,PA4LOOP

                INCW    POINTER        ; NEXT
                DEC     R1
                JP      Z,FADER_IGEN   ; 10 * PULSES FROM TABEL ?
                DEC     R2
                JP      Z,FADER_NEXT
                JP      FADERPLAY

FADER_IGEN:     LD      R0,#20         ; GO BACK TO -20 POSITION IN TABLE.
FADERLP:        DECW    POINTER        ; DECRESE TABLE POINTER
                DJNZ    R0,FADERLP

                LD      R1,#10         ; NEW 10 TIMES TABLE LOOKUP
                JP      FADERPLAY
FADER_NEXT:     LD      R1,#10         ; NUMBER SAMPLES PR. LEVEL
                LD      R2,R3          ; GET NUMBER REPEAT THE SAME LEVEL.
                JP      FADERPLAY

;**** PAUSE SUB ************************************************************

PAUSE:          LD      R5,R15          ; GET DELAY VALUE FROM R15
PAUSELP:        LD      R4,#250
PAUSELPP:       NOP
                DJNZ    R4,PAUSELPP
                DJNZ    R5,PAUSELP
                RET

;****  HERE IS THE LIGHTSHOW DATA ******************************************

D_START3PRIK:
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000010B 
 .BYTE 00000000B,00100010B 
 .BYTE 00000010B,00100010B 
 .BYTE 11111111B           ; END IS FFh

D_SLUT3PRIK:
 .BYTE 00000010B,00100010B 
 .BYTE 00000010B,00100000B 
 .BYTE 00000010B,00000000B 
 .BYTE 00000000B,00000000B
 .BYTE 11111111B           ; END IS FFh

D_3PRIK_VEN:
 .BYTE 00000100B,01000100B 
 .BYTE 00000000B,10001000B 
 .BYTE 00000001B,00010001B 
 .BYTE 00000010B,00100010B 
 .BYTE 11111111B           ; END IS FFh

D_3PRIK_SKIFT:
 .BYTE 00000100B,01000110B
 .BYTE 00000000B,10001100B 
 .BYTE 00000001B,00011001B 
 .BYTE 00000011B,00110010B 
 .BYTE 00000110B,01100110B 
 .BYTE 11111111B           ; END IS FFh

D_3PRIK_K0R:
 .BYTE 00000100B,11001100B 
 .BYTE 00000001B,10011001B 
 .BYTE 00000011B,00110011B 
 .BYTE 00000110B,01100110B 
 .BYTE 11111111B           ; END IS FFh



D_JIM_INTRO:
 .BYTE 00000000B,00000000B 
 .BYTE 00000100B,00000000B 
 .BYTE 00000110B,00000000B 
 .BYTE 00000011B,00000000B 
 .BYTE 00000011B,10000000B 
 .BYTE 00000001B,11000000B 
 .BYTE 00000001B,11100000B 
 .BYTE 00000000B,11110000B 
 .BYTE 11111111B 

D_JIM_OUTRO:
 .BYTE 00000001B,01110000B 
 .BYTE 00000010B,01110000B 
 .BYTE 00000100B,10101000B 
 .BYTE 00000001B,00101000B 
 .BYTE 00000010B,01001000B 
 .BYTE 00000100B,01001000B 
 .BYTE 00000000B,10010000B 
 .BYTE 00000001B,00010000B 
 .BYTE 00000010B,00000000B 
 .BYTE 00000000B,00100000B 
 .BYTE 00000000B,00000000B 
 .BYTE 00000000B,10000000B 
 .BYTE 00000000B,00000000B 
 .BYTE 00000001B,00000000B 
 .BYTE 00000000B,00000000B 
 .BYTE 00000000B,00000000B 
 .BYTE 00000100B,00000000B 
 .BYTE 00000000B,00000000B 
 .BYTE 11111111B 

D_JIM_LOOP1:
 .BYTE 00000000B,11111000B 
 .BYTE 00000000B,01111100B 
 .BYTE 00000000B,01111110B 
 .BYTE 00000000B,00111111B 
 .BYTE 00000000B,00111111B 
 .BYTE 00000000B,00011111B 
 .BYTE 00000000B,00011111B 
 .BYTE 00000000B,00001111B 
 .BYTE 00000000B,00001111B 
 .BYTE 00000000B,00000111B 
 .BYTE 00000000B,00000111B 
 .BYTE 00000100B,00000011B 
 .BYTE 00000110B,00000011B 
 .BYTE 00000011B,00000001B 
 .BYTE 00000011B,10000001B 
 .BYTE 00000001B,11000000B 
 .BYTE 00000001B,11100000B 
 .BYTE 00000000B,11110000B 
 .BYTE 11111111B 

D_JIM_LOOP_SINE:
 .BYTE 00000000B,01011000B 
 .BYTE 00000000B,01001100B 
 .BYTE 00000000B,00100110B 
 .BYTE 00000000B,00100110B 
 .BYTE 00000000B,00100011B 
 .BYTE 00000000B,01000011B 
 .BYTE 00000000B,10000011B 
 .BYTE 00000001B,00000110B 
 .BYTE 00000010B,00000110B 
 .BYTE 00000100B,00001100B 
 .BYTE 00000100B,00011000B 
 .BYTE 00000100B,00110000B 
 .BYTE 00000010B,00110000B 
 .BYTE 00000010B,01100000B 
 .BYTE 00000001B,01100000B 
 .BYTE 00000001B,01100000B 
 .BYTE 00000000B,10110000B 
 .BYTE 00000000B,10110000B 
 .BYTE 11111111B 



D_L0BH0J2:
 .BYTE 00000100B,00000000B 
 .BYTE 00000110B,00000000B 
 .BYTE 00000011B,00000000B 
 .BYTE 00000001B,10000000B 
 .BYTE 00000000B,11000000B 
 .BYTE 00000000B,01100000B 
 .BYTE 00000000B,00110000B 
 .BYTE 00000000B,00011000B 
 .BYTE 00000000B,00001100B 
 .BYTE 00000000B,00000110B 
 .BYTE 00000000B,00000011B 
 .BYTE 00000000B,00000001B 
 .BYTE 11111111B           ; END IS FFh


D_L0BVEN2:
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000011B
 .BYTE 00000000B,00000110B
 .BYTE 00000000B,00001100B
 .BYTE 00000000B,00011000B
 .BYTE 00000000B,00110000B
 .BYTE 00000000B,01100000B
 .BYTE 00000000B,11000000B
 .BYTE 00000001B,10000000B
 .BYTE 00000011B,00000000B
 .BYTE 00000110B,00000000B
 .BYTE 00000100B,00000000B
 .BYTE 11111111B           ; END IS FFh


D_MODMIDT2:
 .BYTE 00000100B,00000001B
 .BYTE 00000110B,00000011B
 .BYTE 00000011B,00000110B
 .BYTE 00000001B,10001100B
 .BYTE 00000000B,11011000B
 .BYTE 00000000B,01110000B
 .BYTE 00000000B,00100000B
 .BYTE 11111111B           ; END IS FFh

D_FRAMIDT2:
 .BYTE 00000000B,00100000B
 .BYTE 00000000B,01110000B
 .BYTE 00000000B,11011000B
 .BYTE 00000001B,10001100B
 .BYTE 00000011B,00000110B
 .BYTE 00000110B,00000011B
 .BYTE 00000100B,00000001B
 .BYTE 00000000B,00000000B
 .BYTE 11111111B           ; END IS FFh



D_L0BVEN_ALL:
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000010B
 .BYTE 00000000B,00000010B
 .BYTE 00000000B,00000010B
 .BYTE 00000000B,00000100B
 .BYTE 00000000B,00000100B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00100000B
 .BYTE 00000000B,01000001B
 .BYTE 00000000B,10000010B
 .BYTE 00000001B,00000100B
 .BYTE 00000010B,00001000B
 .BYTE 00000010B,00010000B
 .BYTE 00000100B,00100000B
 .BYTE 00000100B,01000001B
 .BYTE 00000100B,10000010B
 .BYTE 00000101B,00000100B
 .BYTE 00000101B,00001000B
 .BYTE 00000110B,00010000B
 .BYTE 00000110B,00100000B
 .BYTE 00000110B,01000001B
 .BYTE 00000110B,10000010B
 .BYTE 00000110B,10000100B
 .BYTE 00000111B,00001000B
 .BYTE 00000111B,00010000B
 .BYTE 00000111B,00100000B
 .BYTE 00000111B,01000001B
 .BYTE 00000111B,01000010B
 .BYTE 00000111B,10000100B
 .BYTE 00000111B,10001000B
 .BYTE 00000111B,10010000B
 .BYTE 00000111B,10100000B
 .BYTE 00000111B,10100001B
 .BYTE 00000111B,11000010B
 .BYTE 00000111B,11000100B
 .BYTE 00000111B,11001000B
 .BYTE 00000111B,11010000B
 .BYTE 00000111B,11010000B
 .BYTE 00000111B,11100001B
 .BYTE 00000111B,11100010B
 .BYTE 00000111B,11100100B
 .BYTE 00000111B,11101000B
 .BYTE 00000111B,11101000B
 .BYTE 00000111B,11110000B
 .BYTE 00000111B,11110001B
 .BYTE 00000111B,11110010B
 .BYTE 00000111B,11110100B
 .BYTE 00000111B,11110100B
 .BYTE 00000111B,11111000B
 .BYTE 00000111B,11111000B
 .BYTE 00000111B,11111001B
 .BYTE 00000111B,11111001B
 .BYTE 00000111B,11111010B
 .BYTE 00000111B,11111010B
 .BYTE 00000111B,11111100B
 .BYTE 00000111B,11111100B
 .BYTE 00000111B,11111101B
 .BYTE 00000111B,11111101B
 .BYTE 00000111B,11111110B
 .BYTE 00000111B,11111110B
 .BYTE 00000111B,11111110B
 .BYTE 00000111B,11111111B
 .BYTE 00000111B,11111111B
 .BYTE 11111111B           ; END IS FFh


D_FRA_ALL:
 .BYTE 00000111B,11111111B
 .BYTE 00000011B,11111111B
 .BYTE 00000011B,11111110B
 .BYTE 00000001B,11111110B
 .BYTE 00000001B,11111100B
 .BYTE 00000000B,11111100B
 .BYTE 00000000B,11111000B
 .BYTE 00000000B,01111000B
 .BYTE 00000000B,01110000B
 .BYTE 00000000B,00110000B
 .BYTE 00000000B,00100000B
 .BYTE 11111111B           ; END IS FFh


D_TIL_ALL:
 .BYTE 00000000B,00100000B
 .BYTE 00000000B,00110000B
 .BYTE 00000000B,01110000B
 .BYTE 00000000B,01111000B
 .BYTE 00000000B,11111000B
 .BYTE 00000000B,11111100B
 .BYTE 00000001B,11111100B
 .BYTE 00000001B,11111110B
 .BYTE 00000011B,11111110B
 .BYTE 00000011B,11111111B
 .BYTE 00000111B,11111111B
 .BYTE 11111111B           ; END IS FFh


D_FREMTIL
 .BYTE 00000000B,00100000B
 .BYTE 00000000B,00110000B
 .BYTE 00000000B,00111000B
 .BYTE 00000000B,00111100B
 .BYTE 00000000B,00111100B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,00111111B
 .BYTE 00000000B,00111111B
 .BYTE 00000000B,00111111B
 .BYTE 00000000B,00111111B
 .BYTE 00000000B,00111111B
 .BYTE 00000000B,00111111B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,00111100B
 .BYTE 00000000B,00111100B
 .BYTE 00000000B,00111000B
 .BYTE 00000000B,00110000B
 .BYTE 00000000B,00100000B
 .BYTE 00000000B,01100000B
 .BYTE 00000000B,11100000B
 .BYTE 00000001B,11100000B
 .BYTE 00000001B,11100000B
 .BYTE 00000011B,11100000B
 .BYTE 00000011B,11100000B
 .BYTE 00000011B,11100000B
 .BYTE 00000111B,11100000B
 .BYTE 00000111B,11100000B
 .BYTE 00000111B,11100000B
 .BYTE 00000111B,11100000B
 .BYTE 00000111B,11100000B
 .BYTE 00000111B,11100000B
 .BYTE 00000011B,11100000B
 .BYTE 00000011B,11100000B
 .BYTE 00000011B,11100000B
 .BYTE 00000001B,11100000B
 .BYTE 00000001B,11100000B
 .BYTE 00000000B,11100000B
 .BYTE 00000000B,01100000B
 .BYTE 00000000B,00100000B
 .BYTE 11111111B           ; END IS FFh





D_SINUS:
 .BYTE 00000000B,00100000B
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00001100B
 .BYTE 00000000B,00000100B
 .BYTE 00000000B,00000110B
 .BYTE 00000000B,00000010B
 .BYTE 00000000B,00000011B
 .BYTE 00000000B,00000011B
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000001B
 .BYTE 00000000B,00000011B
 .BYTE 00000000B,00000011B
 .BYTE 00000000B,00000010B
 .BYTE 00000000B,00000110B
 .BYTE 00000000B,00000100B
 .BYTE 00000000B,00001100B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00100000B
 .BYTE 00000000B,01000000B
 .BYTE 00000000B,10000000B
 .BYTE 00000001B,10000000B
 .BYTE 00000001B,00000000B
 .BYTE 00000011B,00000000B
 .BYTE 00000010B,00000000B
 .BYTE 00000110B,00000000B
 .BYTE 00000110B,00000000B
 .BYTE 00000100B,00000000B
 .BYTE 00000100B,00000000B
 .BYTE 00000100B,00000000B
 .BYTE 00000100B,00000000B
 .BYTE 00000110B,00000000B
 .BYTE 00000110B,00000000B
 .BYTE 00000010B,00000000B
 .BYTE 00000011B,00000000B
 .BYTE 00000001B,00000000B
 .BYTE 00000001B,10000000B
 .BYTE 00000000B,10000000B
 .BYTE 00000000B,01000000B
 .BYTE 11111111B           ; END IS FFh


;****************************************************************************
; HERE IS THE PWM TABLE, FOR ALL 11 BITS. MORE 1 GIVE MORE LIGHT.
D_FADER:
 .BYTE 00000011B,11111111B  ; 012-34 68 A8 64
 .BYTE 00000000B,00011100B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,01001001B
 .BYTE 00000001B,10111110B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,01111111B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,11011101B

 .BYTE 00000101B,11111111B  ; 101-23 46 8A 86
 .BYTE 00000000B,00001111B
 .BYTE 00000000B,00011110B
 .BYTE 00000000B,01111111B
 .BYTE 00000000B,00010101B
 .BYTE 00000000B,10001110B
 .BYTE 00000000B,00111111B
 .BYTE 00000000B,01001111B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,00000100B

 .BYTE 00000110B,11111111B  ; 210-12 34 68 A8
 .BYTE 00000000B,00000111B
 .BYTE 00000000B,00001111B
 .BYTE 00000000B,00110010B
 .BYTE 00000000B,00001111B
 .BYTE 00000100B,01011111B
 .BYTE 00000000B,00001111B
 .BYTE 00000000B,00100111B
 .BYTE 00000000B,00011111B
 .BYTE 00000000B,00000010B

 .BYTE 00000111B,01111111B  ; 321-01 23 46 8A
 .BYTE 00000000B,00000111B
 .BYTE 00000000B,00000011B
 .BYTE 00000000B,00011111B
 .BYTE 00000110B,00000101B
 .BYTE 00000000B,00101011B
 .BYTE 00000000B,00000111B
 .BYTE 00000100B,00010111B
 .BYTE 00000000B,00001011B
 .BYTE 00000000B,00000001B

 .BYTE 00000111B,10111111B  ; 432-10 12 34 68
 .BYTE 00000000B,00000001B
 .BYTE 00000100B,00000111B
 .BYTE 00000000B,00001001B
 .BYTE 00000111B,00000010B
 .BYTE 00000000B,00010111B
 .BYTE 00000000B,00000011B
 .BYTE 00000110B,00001001B
 .BYTE 00000000B,00000111B
 .BYTE 00000000B,00000000B

 .BYTE 00000111B,11011111B  ; 643-21 01 23 46
 .BYTE 00000000B,00000000B
 .BYTE 00000110B,00000011B
 .BYTE 00000001B,00000101B
 .BYTE 00000110B,00000001B
 .BYTE 00000100B,10001010B
 .BYTE 00000100B,00000001B
 .BYTE 00000011B,00000100B
 .BYTE 00000100B,00000011B
 .BYTE 00000000B,00000000B

 .BYTE 00000111B,11101111B  ; 864-32 10 12 34
 .BYTE 00000100B,00000000B
 .BYTE 00000110B,00000001B
 .BYTE 00000001B,10000010B
 .BYTE 00000110B,00000000B
 .BYTE 00000100B,01000101B
 .BYTE 00000111B,00000000B
 .BYTE 00000110B,10000010B
 .BYTE 00000111B,00000001B
 .BYTE 00000000B,00000000B

 .BYTE 00000111B,11110111B  ; A86-43 21 01 23
 .BYTE 00000110B,00000000B
 .BYTE 00000111B,00000000B
 .BYTE 00000100B,11000001B
 .BYTE 00000111B,00000000B
 .BYTE 00000111B,10100010B
 .BYTE 00000110B,00000000B
 .BYTE 00000111B,01000001B
 .BYTE 00000101B,10000000B
 .BYTE 00000110B,00000000B

 .BYTE 00000111B,11111011B  ; 8A8-64 32 10 12
 .BYTE 00000111B,00000000B
 .BYTE 00000111B,10000000B
 .BYTE 00000010B,11100000B
 .BYTE 00000111B,00000000B
 .BYTE 00000111B,10000001B
 .BYTE 00000111B,11010000B
 .BYTE 00000111B,00100000B
 .BYTE 00000111B,11000000B
 .BYTE 00000010B,00000000B

 .BYTE 00000111B,11111101B  ; 68A-86 43 21 01
 .BYTE 00000011B,10000000B
 .BYTE 00000111B,01100000B
 .BYTE 00000011B,10010000B
 .BYTE 00000101B,11000000B
 .BYTE 00000111B,11101000B
 .BYTE 00000111B,10000000B
 .BYTE 00000011B,01010000B
 .BYTE 00000111B,10100000B
 .BYTE 00000001B,11000000B

 .BYTE 00000111B,11111110B  ; 468-A8 64 32 10
 .BYTE 00000001B,11100000B
 .BYTE 00000111B,11000000B
 .BYTE 00000010B,11011000B
 .BYTE 00000111B,10100000B
 .BYTE 00000001B,11110100B
 .BYTE 00000011B,11000000B
 .BYTE 00000101B,11111000B
 .BYTE 00000011B,11100000B
 .BYTE 00000000B,10000000B

 .BYTE 00000111B,11111111B  ; 346-8A 86 43 21
 .BYTE 00000000B,11100000B
 .BYTE 00000011B,11111000B
 .BYTE 00000000B,11110100B
 .BYTE 00000111B,01000000B
 .BYTE 00000000B,11111010B
 .BYTE 00000001B,11100000B
 .BYTE 00000110B,11110100B
 .BYTE 00000001B,11101000B
 .BYTE 00000001B,01010000B

 .BYTE 00000111B,11111111B  ; 234-68 A8 64 32
 .BYTE 00000000B,01110000B
 .BYTE 00000000B,11111100B
 .BYTE 00000011B,11110000B
 .BYTE 00000000B,10101010B
 .BYTE 00000100B,01111101B
 .BYTE 00000001B,11110000B
 .BYTE 00000010B,01111010B
 .BYTE 00000001B,11110100B
 .BYTE 00000000B,00101000B

 .BYTE 00000111B,11111111B  ; 123-46 8A 86 43
 .BYTE 00000000B,00111000B
 .BYTE 00000000B,01111110B
 .BYTE 00000001B,10111101B
 .BYTE 00000000B,01010000B
 .BYTE 00000010B,01111110B
 .BYTE 00000000B,10111000B
 .BYTE 00000001B,01111101B
 .BYTE 00000000B,10111110B
 .BYTE 00000000B,01010000B
 .BYTE 11111111B           ; END IS FFh


D_FADE_OP:                  ; FADE LIGHT UP FROM BLACK.
 .BYTE 00000000B,00000000B  ; 000-00 00 00 00
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B

 .BYTE 00000000B,00001000B  ; 000-00 00 10 00
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B

 .BYTE 00000000B,00011100B  ; 000-00 01 21 00
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B

 .BYTE 00000000B,00111110B  ; 000-00 12 32 10
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00010100B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B

 .BYTE 00000000B,01111111B  ; 000-01 23 43 21
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00001100B
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00101100B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00011010B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B

 .BYTE 00000000B,11111111B  ; 000-12 34 64 32
 .BYTE 00000000B,00000100B
 .BYTE 00000000B,00011000B
 .BYTE 00000000B,00101001B
 .BYTE 00000000B,01001110B
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00101000B
 .BYTE 00000000B,00010110B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00000000B

 .BYTE 00000001B,11111111B  ; 001-23 46 86 43
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00111110B
 .BYTE 00000000B,01001001B
 .BYTE 00000000B,00010110B
 .BYTE 00000000B,10101000B
 .BYTE 00000000B,00011100B
 .BYTE 00000000B,01011111B
 .BYTE 00000000B,00101100B
 .BYTE 00000000B,00010000B
 .BYTE 11111111B

D_FADE_NED:                 ; FADE DOWN TO BLACK.
 .BYTE 00000011B,11111111B  ; 012-34 68 64 32
 .BYTE 00000000B,00110000B
 .BYTE 00000000B,00011100B
 .BYTE 00000000B,11110010B
 .BYTE 00000001B,00011100B
 .BYTE 00000000B,01111001B
 .BYTE 00000000B,00010010B
 .BYTE 00000000B,10101100B
 .BYTE 00000000B,01111000B
 .BYTE 00000000B,00000000B

 .BYTE 00000001B,11111111B  ; 001-23 46 43 21
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00100000B
 .BYTE 00000000B,01011100B
 .BYTE 00000000B,10000000B
 .BYTE 00000000B,00111010B
 .BYTE 00000000B,01000000B
 .BYTE 00000000B,00111100B
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00000000B

 .BYTE 00000000B,11111110B  ; 000-12 34 32 10
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00111000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,01010100B
 .BYTE 00000000B,00100000B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00000000B

 .BYTE 00000000B,01111100B  ; 000-01 23 21 00
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00001000B
 .BYTE 00000000B,00110000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B

 .BYTE 00000000B,00111000B  ; 000-00 12 10 00
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00010000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B

 .BYTE 00000000B,00010000B  ; 000-00 01 00 00
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 00000000B,00000000B
 .BYTE 11111111B           ; END IS FFh

.end    
