VERSION 4.00
Begin VB.Form frmMain 
   Caption         =   "Serial EEPROM Programmer"
   ClientHeight    =   4380
   ClientLeft      =   3444
   ClientTop       =   2232
   ClientWidth     =   3564
   Height          =   4764
   Left            =   3396
   LinkTopic       =   "Form1"
   ScaleHeight     =   4380
   ScaleWidth      =   3564
   Top             =   1896
   Width           =   3660
   Begin VB.Frame fraPortAddress 
      Caption         =   "Port Address"
      Height          =   612
      Left            =   120
      TabIndex        =   15
      Top             =   120
      Width           =   1452
      Begin VB.ComboBox cboPortAddress 
         Height          =   288
         Left            =   120
         Style           =   2  'Dropdown List
         TabIndex        =   16
         Top             =   240
         Width           =   1092
      End
   End
   Begin VB.Frame fraSingleByteOperations 
      Caption         =   "Single-byte Operations"
      Height          =   1572
      Left            =   240
      TabIndex        =   8
      Top             =   2040
      Width           =   3012
      Begin VB.TextBox txtByteAddress 
         Height          =   372
         Left            =   840
         TabIndex        =   12
         Text            =   "00"
         Top             =   960
         Width           =   492
      End
      Begin VB.TextBox txtByteToWrite 
         Height          =   372
         Left            =   840
         TabIndex        =   11
         Text            =   "55"
         Top             =   360
         Width           =   492
      End
      Begin VB.CommandButton cmdReadOneByte 
         Caption         =   "Read a  Byte"
         Height          =   492
         Left            =   1560
         TabIndex        =   10
         Top             =   960
         Width           =   1332
      End
      Begin VB.CommandButton cmdProgramOneByte 
         Caption         =   "Write a Byte"
         Height          =   492
         Left            =   1560
         TabIndex        =   9
         Top             =   360
         Width           =   1332
      End
      Begin VB.Label lblByteAddress 
         AutoSize        =   -1  'True
         Caption         =   "address:"
         Height          =   192
         Left            =   120
         TabIndex        =   14
         Top             =   960
         Width           =   636
      End
      Begin VB.Label lblByteToProgram 
         AutoSize        =   -1  'True
         Caption         =   "data:"
         Height          =   192
         Left            =   120
         TabIndex        =   13
         Top             =   480
         Width           =   360
      End
   End
   Begin VB.Frame fraFileOperations 
      Caption         =   "File Operations"
      Height          =   1572
      Left            =   1800
      TabIndex        =   4
      Top             =   360
      Width           =   1572
      Begin VB.CommandButton cmdReadIntoFile 
         Caption         =   "Read EEPROM into a file"
         Height          =   492
         Left            =   120
         TabIndex        =   6
         Top             =   960
         Width           =   1332
      End
      Begin VB.CommandButton cmdProgramFromFile 
         Caption         =   "Write a file to EEPROM"
         Height          =   492
         Left            =   120
         TabIndex        =   5
         Top             =   360
         Width           =   1332
      End
   End
   Begin VB.Timer tmrTimeout 
      Enabled         =   0   'False
      Left            =   480
      Top             =   3240
   End
   Begin VB.Frame fraEepromType 
      Caption         =   "EEPROM Type"
      Height          =   1092
      Left            =   120
      TabIndex        =   0
      Top             =   840
      Width           =   1452
      Begin VB.OptionButton optEepromType 
         Caption         =   "I2C"
         Height          =   252
         Index           =   2
         Left            =   120
         TabIndex        =   3
         TabStop         =   0   'False
         Top             =   720
         Width           =   972
      End
      Begin VB.OptionButton optEepromType 
         Caption         =   "SPI"
         Height          =   252
         Index           =   1
         Left            =   120
         TabIndex        =   2
         TabStop         =   0   'False
         Top             =   480
         Width           =   972
      End
      Begin VB.OptionButton optEepromType 
         Caption         =   "Microwire"
         Height          =   252
         Index           =   0
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   972
      End
   End
   Begin VB.Label lblMessage 
      BackColor       =   &H00FFFFFF&
      Height          =   492
      Left            =   120
      TabIndex        =   7
      Top             =   3720
      Width           =   3252
   End
   Begin MSComDlg.CommonDialog cdlFileReceived 
      Left            =   1800
      Top             =   3840
      _Version        =   65536
      _ExtentX        =   677
      _ExtentY        =   677
      _StockProps     =   0
   End
   Begin MSComDlg.CommonDialog cdlFileToSend 
      Left            =   1200
      Top             =   3720
      _Version        =   65536
      _ExtentX        =   677
      _ExtentY        =   677
      _StockProps     =   0
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
'Bit numbers of output signals at the parallel port's Data port.
'MW (Microwire):
Const DIn = 0
Const CLK = 1
Const CS = 2
'SPI:
Const SI = 3
Const SCK = 4
Const nCS = 5
'I2C (no hardware chip-select):
Const SDAIn = 6
Const SCL = 7
'Bit numbers of input signals at the parallel port's Status port.
'MW:
Const DOut = 3
'SPI:
Const SO = 4
'I2C:
Const SDAOut = 5
Dim EepromSize%
Dim EepromType$
Dim InputPortAddress%
Dim DataRead%
Dim NumberOfBytes%
Dim OutputPortAddress%
Dim DataToWrite%
Dim TimedOut As Boolean

Private Function fncBitRead%(Variable%, BitNumber%)
'Returns the value (0 or 1) of the requested bit in a Variable.
Dim BitValue%
BitValue = 2 ^ BitNumber
fncBitRead = (Variable And BitValue) \ BitValue
End Function

Private Function fncBitWrite(Variable%, BitNumber%, BitValue%)
If BitValue = 0 Then
    fncBitWrite = Variable And (&HFFFF - (2 ^ BitNumber))
Else
    fncBitWrite = Variable Or (2 ^ BitNumber)
End If
End Function

Private Function fncI2CReadBits%()
'Reads eight bits and combines them into a byte.
Dim BitNumber%
Dim BitRead%
fncI2CReadBits = 0
'Write 1 to SDA so the EEPROM can control it; SCL=0
DataToWrite = fncBitWrite(DataToWrite, SDAIn, 1)
DataToWrite = fncBitWrite(DataToWrite, SCL, 0)
Out OutputPortAddress, DataToWrite
'Out OutputPortAddress, SDAIn
For BitNumber = 7 To 0 Step -1
    'Bring SCL high to cause the EEPROM to write a bit.
    DataToWrite = fncBitWrite(DataToWrite, SCL, 1)
    Out OutputPortAddress, DataToWrite
    'Read the bit & gets its value (0 or 1).
    DataRead = Inp(InputPortAddress)
    BitRead = fncBitRead(DataRead, SDAOut)
    'Bring SCL low.
    DataToWrite = fncBitWrite(DataToWrite, SCL, 0)
    Out OutputPortAddress, DataToWrite
    'Add the bit to the byte being read.
    fncI2CReadBits = fncI2CReadBits + (BitRead * (2 ^ BitNumber))
Next BitNumber
End Function

Private Function fncI2CReadOneByte%(ByteAddress%)
'Reads one byte from the EEPROM.
Dim ByteRead%
Dim BitNumber%
Dim BitToWrite%
Dim A8%
'Get address bit 8, which is sent with the write instruction.
A8 = fncBitRead(ByteAddress, 8)
Call I2CSendWriteInstruction(A8)
'Send address bits 0-7
    For BitNumber = 7 To 0 Step -1
        BitToWrite = fncBitRead(ByteAddress, BitNumber)
        Call I2CWriteBit(BitToWrite)
    Next BitNumber
Call I2CWaitForAck
'Now send the Read instruction (but don't resend A7-A0).
Call I2CSendReadInstruction(A8)
'Return the byte read from the EEPROM
fncI2CReadOneByte = fncI2CReadBits()
'Don't wait for Ack, just issue a Stop condition.
Call I2CIssueStopCondition
End Function

Private Function fncMWReadBits%()
'Reads eight bits and combines them into a byte.
Dim BitNumber%
Dim BitRead%
fncMWReadBits = 0
'To start, CLK=0.
DataToWrite = fncBitWrite(DataToWrite, CLK, 0)
DataToWrite = fncBitWrite(DataToWrite, DIn, 0)
Out OutputPortAddress, DataToWrite
For BitNumber = 7 To 0 Step -1
    'Bring CLK high to cause the EEPROM to write a bit.
    DataToWrite = fncBitWrite(DataToWrite, CLK, 1)
    Out OutputPortAddress, DataToWrite
    'Bring CLK low and read the bit.
    DataToWrite = fncBitWrite(DataToWrite, CLK, 0)
    Out OutputPortAddress, DataToWrite
    DataRead = Inp(InputPortAddress)
    BitRead = fncBitRead(DataRead, DOut)
    'Add the bit to the byte being read.
    fncMWReadBits = fncMWReadBits + (BitRead * (2 ^ BitNumber))
Next BitNumber
End Function

Private Function fncMWReadOneByte%(ByteAddress%)
'Read one byte from the EEPROM and display the result.
Dim BitNumber%
Dim BitToWrite%
Call MWSelect
Call MWSendReadInstruction
For BitNumber = 8 To 0 Step -1
    BitToWrite = fncBitRead(ByteAddress, BitNumber)
    Call MWWriteBit(BitToWrite)
Next BitNumber
'Return the byte read from the EEPROM
fncMWReadOneByte = fncMWReadBits()
Call MWDeselect
End Function

Private Function fncSPIReadBits%()
'Reads eight bits and combines them into a byte.
Dim BitNumber%
Dim BitRead%
fncSPIReadBits = 0
'SCK=0.
DataToWrite = fncBitWrite(DataToWrite, SCK, 0)
DataToWrite = fncBitWrite(DataToWrite, SI, 0)
Out OutputPortAddress, DataToWrite
For BitNumber = 7 To 0 Step -1
    'Bring SCK high to cause the EEPROM to send a bit.
    DataToWrite = fncBitWrite(DataToWrite, SCK, 1)
    Out OutputPortAddress, DataToWrite
    'Read the bit & gets its value (0 or 1).
    DataRead = Inp(InputPortAddress)
    BitRead = fncBitRead(DataRead, SO)
    'Add the bit to the byte being read.
    fncSPIReadBits = fncSPIReadBits + (BitRead * (2 ^ BitNumber))
    'Bring SCK low.
    DataToWrite = fncBitWrite(DataToWrite, SCK, 0)
    Out OutputPortAddress, DataToWrite
Next BitNumber
End Function

Private Function fncSPIReadOneByte%(ByteAddress%)
Dim ByteRead%
Dim BitNumber%
Dim BitToWrite%
Dim A8%
'Get address bit 8, which is sent with the read instruction.
A8 = fncBitRead(ByteAddress, 8)
Call SPISelect
Call SPISendReadInstruction(A8)
'Send address bits 7-0:
For BitNumber = 7 To 0 Step -1
    BitToWrite = fncBitRead(ByteAddress, BitNumber)
    Call SPIWriteBit(BitToWrite)
Next BitNumber
'Return the byte read from the EEPROM
fncSPIReadOneByte = fncSPIReadBits()
Call SPIDeselect
lblMessage.Caption = "Byte read = " + Hex$(Val(ByteRead)) + _
"h at address " + Hex$(Val(ByteAddress)) + "h"
End Function

Private Sub cboPortAddress_Click()
'Gets the selected port address
OutputPortAddress = Val("&h" + cboPortAddress.Text)
InputPortAddress = OutputPortAddress + 1
End Sub

Private Sub cmdProgramFromFile_Click()
'Allows the user to select a file to send to the EEPROM.
'Opens the file and calls the appropriate programming routine.
Dim FileLength%
Dim SelectedFile$
'Settings for common dialog box:
Const OFN_FILEMUSTEXIST = &H1000&
cdlFileToSend.Filter = "All files (*.*)|*.*"
cdlFileToSend.filename = ""
cdlFileToSend.Flags = OFN_FILEMUSTEXIST
lblMessage.Caption = ""
'Get the selected file.
cdlFileToSend.Action = 1
SelectedFile = cdlFileToSend.filename
Open SelectedFile For Binary Access Read As #1
FileLength = LOF(1)
If FileLength > EepromSize + 1 Then FileLength = EepromSize + 1
lblMessage.Caption = "Programming..."
Select Case EepromType
    Case "Microwire"
        Call MWProgramFromFile
    Case "SPI"
        Call SPIProgramFromFile
    Case "I2C"
        Call I2CProgramFromFile
End Select
Close #1
If TimedOut = False Then
    lblMessage.Caption = "Programming completed"
Else
    TimedOut = False
End If
End Sub

Private Sub cmdProgramOneByte_Click()
'Reads the byte value and address from the text boxes &
'calls the appropriate programming routine.
Dim ByteToWrite%
Dim ByteAddress%
lblMessage.Caption = ""
ByteToWrite = CInt("&h" + txtByteToWrite.Text)
ByteAddress = CInt("&h" + txtByteAddress.Text)
Select Case EepromType
    Case "Microwire"
        Call MWProgramOneByte(ByteToWrite, ByteAddress)
    Case "SPI"
        Call SPIProgramOneByte(ByteToWrite, ByteAddress)
    Case "I2C"
        Call I2CProgramOneByte(ByteToWrite, ByteAddress)
End Select
If TimedOut = False Then
    lblMessage.Caption = "Byte " & Hex(ByteToWrite) _
        + "h programmed into address " & Hex(ByteAddress) & "h"
Else
    TimedOut = False
End If
End Sub

Private Sub cmdReadIntoFile_Click()
'Reads the contents of the EEPROM into a file.
'Gets the filename and calls the appropriate Read routine.
Dim FileReceived$
Dim SelectedFile$
'Settings for Common Dialog box:
Const OFN_OVERWRITEPROMPT = &H2&
Const OFN_CREATEPROMPT = &H2000&
cdlFileReceived.Filter = "All files (*.*)|*.*"
cdlFileReceived.filename = ""
cdlFileReceived.Flags = OFN_OVERWRITEPROMPT
cdlFileReceived.Flags = OFN_CREATEPROMPT
cdlFileReceived.Action = 2
SelectedFile = cdlFileReceived.filename
Open SelectedFile For Binary Access Write As #1
lblMessage.Caption = ""
Select Case EepromType
    Case "Microwire"
        Call MWReadAll
    Case "SPI"
        Call SPIReadAll
    Case "I2C"
        Call I2CReadAll
End Select
Close #1
If TimedOut = False Then
    lblMessage.Caption = "Read operation completed"
Else
    TimedOut = False
End If
End Sub

Private Sub cmdReadOneByte_Click()
'Reads one byte from the EEPROM and displays the result.
Dim ByteAddress%
Dim ByteRead%
lblMessage.Caption = ""
'Get address from the text box.
ByteAddress = CInt("&h" + txtByteAddress.Text)
Select Case EepromType
    Case "Microwire"
        ByteRead = fncMWReadOneByte(ByteAddress)
    Case "SPI"
        ByteRead = fncSPIReadOneByte(ByteAddress)
    Case "I2C"
        ByteRead = fncI2CReadOneByte(ByteAddress)
End Select
If TimedOut = False Then
    lblMessage.Caption = "Byte read = " + Hex$(Val(ByteRead)) + _
        "h at address " + Hex$(Val(ByteAddress)) + "h"
Else
    TimedOut = False
End If
End Sub

Private Sub Form_Load()
'Serial EEPROM programmer
'by Jan Axelson (email: jaxelson@lvr.com, web: http://www.lvr.com)
'This program accompanies the article
'"A Parallel-port Serial EEPROM Programmer",
'published in Circuit Cellar Ink magazine.
'Written for Visual Basic 4, 16- or 32-bit.
'Uses the file inpoutv4.bas (contains Inp, Out DLL declarations).

'Store the most common port addresses in the list box.
cboPortAddress.AddItem "278h"
cboPortAddress.AddItem "378h"
cboPortAddress.AddItem "3BCh"
'Select a default port address, EEPROM type.
cboPortAddress.ListIndex = 0
optEepromType(0).Value = True
'Assume 0.5-kilobyte EEPROMs
EepromSize = 511
tmrTimeout.Interval = 3000
tmrTimeout.Enabled = False
'Deselect all chips, bring data and clock outputs low.
DataToWrite = 0
Out OutputPortAddress, 0
Call MWDeselect
Call SPIDeselect
DataToWrite = 0
TimedOut = False
End Sub

Private Sub I2CIssueStartCondition()
'With SCL high, bring SDA low.
DataToWrite = fncBitWrite(DataToWrite, SDAIn, 1)
DataToWrite = fncBitWrite(DataToWrite, SCL, 0)
Out OutputPortAddress, DataToWrite
DataToWrite = fncBitWrite(DataToWrite, SCL, 1)
Out OutputPortAddress, DataToWrite
DataToWrite = fncBitWrite(DataToWrite, SDAIn, 0)
Out OutputPortAddress, DataToWrite
End Sub

Private Sub I2CIssueStopCondition()
'With SCL high, bring SDA high.
DataToWrite = fncBitWrite(DataToWrite, SCL, 1)
DataToWrite = fncBitWrite(DataToWrite, SDAIn, 0)
Out OutputPortAddress, DataToWrite
DataToWrite = fncBitWrite(DataToWrite, SDAIn, 1)
Out OutputPortAddress, DataToWrite
End Sub

Private Sub I2CProgramFromFile()
Dim ByteNumber%
Dim ByteToWrite%
For ByteNumber = 0 To EepromSize
    'Read a byte from the file
    Get #1, ByteNumber + 1, ByteToWrite
    ByteToWrite = ByteToWrite And &HFF
    Call I2CProgramOneByte(ByteToWrite, ByteNumber)
Next ByteNumber
End Sub

Private Sub I2CProgramOneByte(ByteToWrite%, ByteAddress%)
Dim A8%
Dim BitNumber%
Dim BitToWrite%
'Get address bit 8 and send it with the write instruction.
A8 = fncBitRead(ByteAddress, 8)
Call I2CIssueStartCondition
Call I2CSendWriteInstruction(A8)
'Send address bits 7-0
    For BitNumber = 7 To 0 Step -1
        BitToWrite = fncBitRead(ByteAddress, BitNumber)
        Call I2CWriteBit(BitToWrite)
    Next BitNumber
Call I2CWaitForAck
'Send the data byte
    For BitNumber = 7 To 0 Step -1
        BitToWrite = fncBitRead(ByteToWrite, BitNumber)
        Call I2CWriteBit(BitToWrite)
    Next BitNumber
Call I2CWaitForAck
Call I2CIssueStopCondition
'The Eeprom now programs the data.
'Programming is completed when the EEPROM sends an Ack
'in response to a dummy write instruction.
tmrTimeout.Enabled = True
TimedOut = False
Dim Ack%
Do
    Call I2CIssueStartCondition
    'Send the dummy write instruction.
    Call I2CWriteBit(1)
    Call I2CWriteBit(0)
    Call I2CWriteBit(1)
    Call I2CWriteBit(0)
    Call I2CWriteBit(0)
    Call I2CWriteBit(0)
    Call I2CWriteBit(A8)
    Call I2CWriteBit(0)
    'On the 9th clock cycle, release SDA and wait for the slave to pull it low.
    DataToWrite = fncBitWrite(DataToWrite, SCL, 0)
    DataToWrite = fncBitWrite(DataToWrite, SDAIn, 1)
    Out OutputPortAddress, DataToWrite
    DataToWrite = fncBitWrite(DataToWrite, SCL, 1)
    Out OutputPortAddress, DataToWrite
    DataRead = Inp(InputPortAddress)
    Ack = fncBitRead(DataRead, SDAOut)
    DataToWrite = fncBitWrite(DataToWrite, SCL, 0)
    Out OutputPortAddress, DataToWrite
    DoEvents
Loop Until Ack = 0 Or TimedOut = True
Call I2CIssueStopCondition
tmrTimeout.Enabled = False
End Sub

Private Sub I2CReadAll()
'Write the contents of the EEPROM into the file selected by the user.
Dim ByteRead%
Dim ByteNumber%
Dim BitNumber%
Dim BitToWrite%
Dim A8%
'Begin at address = 0
'Address bit 8 is sent with the read instruction.
A8 = 0
Call I2CSendWriteInstruction(A8)
'Send address bits 0-7
    For BitNumber = 7 To 0 Step -1
        Call I2CWriteBit(0)
    Next BitNumber
Call I2CWaitForAck
Call I2CSendReadInstruction(A8)
For ByteNumber = 1 To EepromSize + 1
    'Read a byte from the EEPROM
    ByteRead = fncI2CReadBits()
    'Write the byte to the selected file.
    Put #1, ByteNumber, ByteRead
    'Issue Ack (SDAout=0) to cause the EEPROM to write the next byte in sequence.
    DataToWrite = fncBitWrite(DataToWrite, SCL, 0)
    DataToWrite = fncBitWrite(DataToWrite, SDAIn, 0)
    Out OutputPortAddress, DataToWrite
    DataToWrite = fncBitWrite(DataToWrite, SCL, 1)
    Out OutputPortAddress, DataToWrite
Next ByteNumber
Call I2CIssueStopCondition
End Sub

Private Sub I2CSendReadInstruction(A8%)
'The read instruction consists of the device identifier (1010),
'two don't cares, address bit 8, and 1 (Read).
Call I2CIssueStartCondition
Call I2CWriteBit(1)
Call I2CWriteBit(0)
Call I2CWriteBit(1)
Call I2CWriteBit(0)
Call I2CWriteBit(0)
Call I2CWriteBit(0)
Call I2CWriteBit(A8)
Call I2CWriteBit(1)
Call I2CWaitForAck
End Sub

Private Sub I2CSendWriteInstruction(A8%)
Call I2CIssueStartCondition
'The write instruction consists of the device identifier (1010),
'two don't cares, address bit 8, and 0 (Write)
Call I2CWriteBit(1)
Call I2CWriteBit(0)
Call I2CWriteBit(1)
Call I2CWriteBit(0)
Call I2CWriteBit(0)
Call I2CWriteBit(0)
Call I2CWriteBit(A8)
Call I2CWriteBit(0)
Call I2CWaitForAck
End Sub

Private Sub I2CWaitForAck()
'Read SDA until SDA = 0
Dim Ack%
TimedOut = False
tmrTimeout.Enabled = True
'Bring SDA high to enable the slave to pull it low.
DataToWrite = fncBitWrite(DataToWrite, SCL, 0)
DataToWrite = fncBitWrite(DataToWrite, SDAIn, 1)
Out OutputPortAddress, DataToWrite
DataToWrite = fncBitWrite(DataToWrite, SCL, 1)
Out OutputPortAddress, DataToWrite
Do
    DataRead = Inp(InputPortAddress)
    Ack = fncBitRead(DataRead, SDAOut)
    DoEvents
Loop Until Ack = 0 Or TimedOut = True
'Bring SCL low.
DataToWrite = fncBitWrite(DataToWrite, SCL, 0)
Out OutputPortAddress, DataToWrite
tmrTimeout.Enabled = False
End Sub

Private Sub I2CWriteBit(BitToWrite%)
'Write the bit with SCL=0,
'then bring SCL high to latch the bit into the EEPROM.
DataToWrite = fncBitWrite(DataToWrite, SCL, 0)
Out OutputPortAddress, DataToWrite
DataToWrite = fncBitWrite(DataToWrite, SDAIn, BitToWrite)
Out OutputPortAddress, DataToWrite
DataToWrite = fncBitWrite(DataToWrite, SCL, 1)
Out OutputPortAddress, DataToWrite
End Sub

Private Sub MWDeselect()
DataToWrite = fncBitWrite(DataToWrite, CS, 0)
Out OutputPortAddress, DataToWrite
End Sub

Private Sub MWProgramFromFile()
Dim ByteNumber%
Dim ByteToWrite%
Call MWWriteEnable
For ByteNumber = 0 To EepromSize
    'Read a byte from the file
    Get #1, ByteNumber + 1, ByteToWrite
    ByteToWrite = ByteToWrite And &HFF
    Call MWProgramOneByte(ByteToWrite, ByteNumber)
Next ByteNumber
End Sub

Private Sub MWProgramOneByte(ByteToWrite%, ByteAddress%)
Dim BitNumber%
Dim BitToWrite%
Call MWWriteEnable
Call MWSelect
Call MWSendWriteInstruction
'Send the address
For BitNumber = 8 To 0 Step -1
    BitToWrite = fncBitRead(ByteAddress, BitNumber)
    Call MWWriteBit(BitToWrite)
Next BitNumber
'Send the data byte
For BitNumber = 7 To 0 Step -1
    BitToWrite = fncBitRead(ByteToWrite, BitNumber)
    Call MWWriteBit(BitToWrite)
Next BitNumber
'Bring CS low to cause the EEPROM to program the byte.
Call MWDeselect
Call MWSelect
Call MWWaitForNotBusy
Call MWDeselect
End Sub

Private Sub MWReadAll()
'Write the contents of the EEPROM into the file selected by the user.
Dim ByteRead%
Dim ByteNumber%
Dim BitNumber%
Call MWSelect
Call MWSendReadInstruction
ByteNumber = 0
'Send the first address (0)
For BitNumber = 8 To 0 Step -1
     Call MWWriteBit(0)
Next BitNumber
'The EEPROM sends the bytes in sequence. The address increments automatically.
For ByteNumber = 1 To EepromSize + 1
    'Read a byte from the EEPROM.
    ByteRead = fncMWReadBits
    'Write the byte to the selected file.
    Put #1, ByteNumber, ByteRead
Next ByteNumber
Call MWDeselect
End Sub

Private Sub MWSelect()
DataToWrite = fncBitWrite(DataToWrite, CS, 1)
Out OutputPortAddress, DataToWrite
End Sub

Private Sub MWSendReadInstruction()
'Send the Start bit (1) and Read instruction (1,0):
Call MWWriteBit(1)
Call MWWriteBit(1)
Call MWWriteBit(0)
End Sub

Private Sub MWSendWriteInstruction()
'Send the Start bit (1) and Write instruction (0,1):
Call MWWriteBit(1)
Call MWWriteBit(0)
Call MWWriteBit(1)
End Sub

Private Sub MWWaitForNotBusy()
'Wait for DOut to return high, indicating EEPROM is not busy.
Dim Busy%
TimedOut = False
tmrTimeout.Enabled = True
Busy = True
Do
    DataRead = Inp(InputPortAddress)
    Busy = fncBitRead(DataRead, DOut)
    DoEvents
Loop Until Busy > 0 Or TimedOut = True
tmrTimeout.Enabled = False
End Sub

Private Sub MWWriteBit(BitToWrite%)
'Write the bit on CLK's falling edge,
'then set CLK=1 to latch the data into the EEPROM.
DataToWrite = fncBitWrite(DataToWrite, DIn, BitToWrite)
DataToWrite = fncBitWrite(DataToWrite, CLK, 0)
Out OutputPortAddress, DataToWrite
DataToWrite = fncBitWrite(DataToWrite, CLK, 1)
Out OutputPortAddress, DataToWrite
End Sub

Private Sub MWWriteEnable()
'The Erase/Write Enable instruction is
'1,0,0,1,1, followed by 7 don't cares.
Dim BitNumber%
Call MWSelect
Call MWWriteBit(1)
Call MWWriteBit(0)
Call MWWriteBit(0)
Call MWWriteBit(1)
Call MWWriteBit(1)
For BitNumber = 5 To 11
    Call MWWriteBit(0)
Next BitNumber
Call MWDeselect
End Sub

Private Sub optEepromType_Click(Index As Integer)
'Selects an EEPROM type.
Index = -1
Do
    Index = Index + 1
Loop Until optEepromType(Index).Value = True
Select Case Index
    Case 0
        EepromType = "Microwire"
    Case 1
        EepromType = "SPI"
    Case 2
        EepromType = "I2C"
End Select
End Sub

Private Sub SPIDeselect()
DataToWrite = fncBitWrite(DataToWrite, nCS, 1)
Out OutputPortAddress, DataToWrite
End Sub

Private Sub SPIDisableBlockProtect()
Dim BitNumber%
Call SPIWriteEnable
Call SPISelect
'Send the Write-to-Status-Register instruction.
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(1)
'Set bit 2=0, bit 3=0. Other bits = don't care.
For BitNumber = 7 To 0 Step -1
    Call SPIWriteBit(0)
Next BitNumber
Call SPIDeselect
Call SPISelect
Call SPIWaitForNotBusy
Call SPIDeselect
If TimedOut = True Then
    lblMessage.Caption = "Timed out - EEPROM not responding."
End If
End Sub

Private Sub SPIProgramFromFile()
Dim ByteNumber%
Dim ByteToWrite%
Call SPIDisableBlockProtect
Call SPISelect
For ByteNumber = 0 To EepromSize
    'Read a byte from the file
    Get #1, ByteNumber + 1, ByteToWrite
    ByteToWrite = ByteToWrite And &HFF
    Call SPIProgramOneByte(ByteToWrite, ByteNumber)
    Call SPIDeselect
Next ByteNumber
End Sub

Private Sub SPIProgramOneByte(ByteToWrite%, ByteNumber%)
Dim BitNumber%
Dim BitToWrite%
Dim A8%
Call SPIDisableBlockProtect
Call SPIWriteEnable
'Get address bit 8, which is included in the write instruction.
A8 = fncBitRead(ByteNumber, 8)
Call SPISelect
Call SPISendWriteInstruction(A8)
'Send address bits 7-0 (from ByteNumber)
For BitNumber = 7 To 0 Step -1
    BitToWrite = fncBitRead(ByteNumber, BitNumber)
    Call SPIWriteBit(BitToWrite)
Next BitNumber
'Send the data byte
For BitNumber = 7 To 0 Step -1
    BitToWrite = fncBitRead(ByteToWrite, BitNumber)
    Call SPIWriteBit(BitToWrite)
Next BitNumber
Call SPIDeselect
Call SPIWaitForNotBusy
End Sub

Private Sub SPIReadAll()
'Write the contents of the EEPROM into the file selected by the user.
Dim ByteRead%
Dim ByteNumber%
Dim BitNumber%
Dim BitToWrite%
Dim A8%
'Begin at address = 0
'Address bit 8 is sent with the read instruction.
A8 = 0
Call SPISelect
Call SPISendReadInstruction(A8)
'Send address bits 7-0:
For BitNumber = 7 To 0 Step -1
    Call SPIWriteBit(0)
Next BitNumber
For ByteNumber = 1 To EepromSize + 1
    'Read a byte from the EEPROM
    ByteRead = fncSPIReadBits
    'Write the byte to the selected file.
    Put #1, ByteNumber, ByteRead
Next ByteNumber
Call SPIDeselect
End Sub

Private Sub SPISelect()
DataToWrite = fncBitWrite(DataToWrite, nCS, 0)
Out OutputPortAddress, DataToWrite
End Sub

Private Sub SPISendReadInstruction(A8%)
'Sends the Read Instruction:
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(A8)
Call SPIWriteBit(0)
Call SPIWriteBit(1)
Call SPIWriteBit(1)
End Sub

Private Sub SPISendWriteInstruction(A8%)
'Sends the Write instruction:
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(A8)
Call SPIWriteBit(0)
Call SPIWriteBit(1)
Call SPIWriteBit(0)
End Sub

Private Sub SPIWaitForNotBusy()
Dim Busy%
Dim BitRead%
Dim BitNumber%
Dim NReady%
TimedOut = False
tmrTimeout.Enabled = True
Call SPISelect
'Wait for bit 0 of the EEPROM's status register to return low,
'indicating EEPROM is not busy.
Do
    'Write the Read Status Register instruction
    Call SPIWriteBit(0)
    Call SPIWriteBit(0)
    Call SPIWriteBit(0)
    Call SPIWriteBit(0)
    Call SPIWriteBit(0)
    Call SPIWriteBit(1)
    Call SPIWriteBit(0)
    Call SPIWriteBit(1)
    'Rising edges of SCK cause the EEPROM to write the
    'status register bits.
    'Bits 1-7 are don't care.
    For BitNumber = 7 To 0 Step -1
        DataToWrite = fncBitWrite(DataToWrite, SCK, 1)
        Out OutputPortAddress, DataToWrite
        DataToWrite = fncBitWrite(DataToWrite, SCK, 0)
        Out OutputPortAddress, DataToWrite
    Next BitNumber
    'Read the final bit (bit 0).
    DataRead = Inp(InputPortAddress)
    NReady = fncBitRead(DataRead, SO)
    SPIDeselect
    SPISelect
    DoEvents
Loop Until NReady = 0 Or TimedOut = True
SPIDeselect
tmrTimeout.Enabled = False
End Sub

Private Sub SPIWriteBit(BitToWrite%)
'Write the bit on SCK's rising edge,
'then bring SCK low to latch the data into the EEPROM.
DataToWrite = fncBitWrite(DataToWrite, SI, BitToWrite)
DataToWrite = fncBitWrite(DataToWrite, SCK, 1)
Out OutputPortAddress, DataToWrite
DataToWrite = fncBitWrite(DataToWrite, SCK, 0)
Out OutputPortAddress, DataToWrite
End Sub

Private Sub SPIWriteEnable()
'Sends the Write Enable instruction.
Call SPISelect
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(0)
Call SPIWriteBit(1)
Call SPIWriteBit(1)
Call SPIWriteBit(0)
Call SPIDeselect
End Sub

Private Sub tmrTimeout_Timer()
'Detects and displays a message when the EEPROM isn't responding.
tmrTimeout.Enabled = False
TimedOut = True
lblMessage.Caption = "Timed out - EEPROM not responding."
End Sub

